/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.tag.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_3494;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.quiltmc.qsl.lifecycle.api.event.ServerLifecycleEvents;
import org.quiltmc.qsl.tag.api.QuiltTagKey;
import org.quiltmc.qsl.tag.api.TagRegistry;
import org.quiltmc.qsl.tag.api.TagType;
import org.quiltmc.qsl.tag.impl.client.ClientTagRegistryManager;
import org.quiltmc.qsl.tag.mixin.DynamicRegistryManagerAccessor;

@ApiStatus.Internal
public final class TagRegistryImpl
implements ServerLifecycleEvents.Stopped {
    private static final Map<class_6862<?>, class_3494<class_6880<?>>> TAGS = new Object2ObjectOpenHashMap();

    public static boolean isRegistryDynamic(class_5321<? extends class_2378<?>> registryKey) {
        return DynamicRegistryManagerAccessor.getInfos().containsKey(registryKey);
    }

    public static void populateTags(Map<class_6862<?>, List<class_6880<?>>> tags) {
        tags.forEach((key, values) -> TAGS.put((class_6862<?>)key, (class_3494<class_6880<?>>)new class_3494((Collection)values)));
    }

    public static void resetTags() {
        TAGS.clear();
    }

    public static <T> class_3494<class_6880<T>> getTag(class_6862<T> key) {
        TagType type = ((QuiltTagKey)key).type();
        if (type.hasSync()) {
            class_3494 tag = TAGS.get(key);
            if (tag == null) {
                tag = type == TagType.CLIENT_FALLBACK ? ClientTagRegistryManager.get(key.comp_326()).getFallbackTag(key) : class_3494.method_40088();
            }
            return tag;
        }
        if (type == TagType.CLIENT_ONLY) {
            return ClientTagRegistryManager.get(key.comp_326()).getClientTag(key);
        }
        return class_3494.method_40088();
    }

    public static <T> Stream<TagRegistry.TagEntry<T>> streamTags(class_5321<? extends class_2378<T>> registry) {
        return TAGS.entrySet().stream().filter(entry -> ((class_6862)entry.getKey()).comp_326() == registry).map(entry -> new TagRegistry.TagEntry((class_6862)entry.getKey(), (class_3494)entry.getValue()));
    }

    public static <T> Stream<TagRegistry.TagEntry<T>> streamTagsWithFallback(class_5321<? extends class_2378<T>> registry) {
        return Stream.concat(TAGS.entrySet().stream().filter(entry -> ((class_6862)entry.getKey()).comp_326() == registry).map(entry -> new TagRegistry.TagEntry((class_6862)entry.getKey(), (class_3494)entry.getValue())), ClientTagRegistryManager.get(registry).streamFallbackTags(entry -> !TAGS.containsKey(entry.getKey())));
    }

    public void exitServer(MinecraftServer server) {
        TagRegistryImpl.resetTags();
    }
}

